/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api.wsrr;

import filenet.vw.api.VWException;
import filenet.vw.api.VWSession;
import filenet.vw.base.VWWSRRRegistry;
import filenet.vw.base.VWWSRRRegistryList;
import filenet.vw.base.logging.Logger;
import filenet.ws.api.wsrr.WSWSRRRegistry;
import java.net.URL;

public class P8WSRRDocumentURI {
    protected static Logger logger = Logger.getLogger("filenet.ws.api.wsrr");
    protected static final String m_className = "P8WSRRDocumentURI";
    private static String RegistryContent = "/RegistryContent/";
    public static String WSRR_PREFIX = "wsrr";
    public static final String P8BPM_WSRR_URI_DELIM = "!";
    private static final int NREQUIRED = 4;
    private URL m_url = null;
    private String m_bsrURI = null;
    private String m_host = null;
    private int m_port = -1;
    private String m_username = null;
    private String m_password = null;
    private WSWSRRRegistry m_wsrrRegistry = null;

    public static boolean isWSRRURI(String wsrrURI) {
        try {
            new P8WSRRDocumentURI(wsrrURI);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    P8WSRRDocumentURI(String uri) throws VWException {
        this.parse(uri);
    }

    P8WSRRDocumentURI(WSWSRRRegistry wsrrRegistry, String bsrURI) throws VWException {
        if (bsrURI == null) {
            throw new VWException("filenet.ws.api.wsrr.P8WSRRDocumentURI.missingWSRRbsrURI", "Missing WSRR document bsrURI.");
        }
        if (wsrrRegistry == null) {
            throw new VWException("filenet.ws.api.wsrr.P8WSRRDocumentURI.wsrrRegirstryRequired", "WSRR registry object required to create P8WSRRDocumentURI");
        }
        this.m_bsrURI = bsrURI;
        this.m_wsrrRegistry = wsrrRegistry;
        this.m_host = wsrrRegistry.getRegisteryHostName();
        this.m_port = wsrrRegistry.getPort();
    }

    void parse(String uri) throws VWException {
        try {
            String bsrURI;
            this.m_bsrURI = null;
            this.m_url = new URL(uri);
            this.m_host = this.m_url.getHost();
            this.m_port = this.m_url.getPort();
            String path = this.m_url.getPath();
            if (path != null && path.indexOf(RegistryContent) == 0 && (bsrURI = path.substring(RegistryContent.length())).indexOf("/") == -1) {
                this.m_bsrURI = bsrURI;
            }
        }
        catch (Exception ex) {
            throw new VWException(ex);
        }
        if (this.m_bsrURI == null) {
            throw new VWException("filenet.ws.api.wsrr.P8WSRRDocumentURI.NoValidWSRRURI", "Invalid WSRR URI");
        }
    }

    public String toString() {
        if (this.m_url == null) {
            try {
                this.m_url = new URL("http", this.m_host, this.m_port, RegistryContent + this.m_bsrURI);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.m_url != null) {
            return this.m_url.toString();
        }
        return null;
    }

    public String getHose() {
        return this.m_host;
    }

    public String getBsrURI() {
        return this.m_bsrURI;
    }

    public WSWSRRRegistry getWSWSRRRegistry(VWSession session) throws VWException {
        if (this.m_wsrrRegistry == null) {
            this.m_wsrrRegistry = WSWSRRRegistry.newWSRRRegistry(session, this.m_host, this.m_port);
            VWWSRRRegistry vwWsrrRegistry = VWWSRRRegistryList.getWSRRRegistry(session, this.m_host, this.m_port);
            if (vwWsrrRegistry != null) {
                this.m_username = vwWsrrRegistry.getUserName();
                this.m_password = vwWsrrRegistry.getPassword();
                if (this.m_username != null && this.m_password != null) {
                    if (this.m_wsrrRegistry.validateUser(this.m_username, this.m_password)) {
                        this.m_wsrrRegistry.setQueryUsernamePassword(this.m_username, this.m_password);
                    } else {
                        throw new VWException("filenet.ws.api.wsrr.P8WSRRDocumentURI.InvalidWSRRUsernamePassword", "Invalid WSRR username and password.");
                    }
                }
            }
        }
        return this.m_wsrrRegistry;
    }

    public static String _get_FILE_DATE() {
        return "$Date:   30 Sep 2008 14:49:20  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.7  $";
    }
}

